/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import wile.redstonepen.libmc.Guis;

@OnlyIn(value=Dist.CLIENT)
public class GuiTextEditing {

    @OnlyIn(value=Dist.CLIENT)
    public static class MultiLineTextBox
    extends Guis.UiWidget
    implements GuiEventListener {
        private static final int NORM_LINE_HEIGHT = 9;
        private static final Consumer<MultiLineTextBox> ON_CHANGE_IGNORED = tb -> {};
        private static final BiConsumer<MultiLineTextBox, Guis.Coord2d> ON_MOUSEMOVE_IGNORED = (xy, tb) -> {};
        private int frame_tick_;
        private long last_clicked_ = 0L;
        private int last_index_ = -1;
        private final TextFieldHelper edit_;
        private String text_ = "";
        private Font font_;
        private int line_height_ = 9;
        private float font_scale_ = 1.0f;
        private int max_text_size_ = 1024;
        private int font_color_ = -16777216;
        private int cursor_color_ = -16777216;
        private Consumer<MultiLineTextBox> on_changed_ = ON_CHANGE_IGNORED;
        private BiConsumer<MultiLineTextBox, Guis.Coord2d> on_mouse_move_ = ON_MOUSEMOVE_IGNORED;
        @Nullable
        private DisplayCache display_cache_ = DisplayCache.EMPTY;

        public MultiLineTextBox(int x, int y, int width, int height, Component title) {
            super(x, y, width, height, title);
            this.edit_ = new TextFieldHelper(this::getText, this::setText, this::getClipboard, this::setClipboard, s -> s.length() < this.max_text_size_ && this.font_.m_92920_(s, width * 9 / this.line_height_) <= height * 9 / this.line_height_);
        }

        public String getValue() {
            return MultiLineTextBox.eotTrimmed(this.text_);
        }

        public MultiLineTextBox setValue(String text) {
            if (text.length() > this.getMaxLength()) {
                text = text.substring(0, this.getMaxLength());
            }
            if (!this.text_.equals(text)) {
                if (this.edit_ == null) {
                    this.text_ = MultiLineTextBox.eotTrimmed(text);
                } else {
                    boolean to_end = this.text_.isEmpty();
                    int cur = this.edit_.m_95194_();
                    int sel = this.edit_.m_95197_();
                    this.edit_.m_95188_();
                    this.edit_.m_95158_(MultiLineTextBox.eotTrimmed(text));
                    if (to_end) {
                        sel = cur = this.text_.length();
                    }
                    this.edit_.m_169100_(sel);
                    this.edit_.m_169098_(cur);
                }
                this.clearDisplayCache();
            }
            return this;
        }

        public int getMaxLength() {
            return this.max_text_size_;
        }

        public MultiLineTextBox setMaxLength(int size) {
            this.max_text_size_ = Mth.m_14045_((int)size, (int)2, (int)1024);
            if (this.text_.length() > this.max_text_size_) {
                this.text_ = MultiLineTextBox.eotTrimmed(this.text_.substring(0, this.max_text_size_));
                this.on_changed_.accept(this);
            }
            return this;
        }

        public Font getFont() {
            return this.font_;
        }

        public MultiLineTextBox setFont(Font fnt) {
            this.font_ = fnt;
            return this;
        }

        public int getFontColor() {
            return this.font_color_;
        }

        public MultiLineTextBox setFontColor(int color) {
            this.font_color_ = color | 0xFF000000;
            return this;
        }

        public int getCursorColor() {
            return this.cursor_color_;
        }

        public MultiLineTextBox setCursorColor(int color) {
            this.cursor_color_ = color | 0xFF000000;
            return this;
        }

        public int getLineHeight() {
            return this.line_height_;
        }

        public MultiLineTextBox setLineHeight(int h) {
            this.line_height_ = Mth.m_14045_((int)h, (int)6, (int)9);
            this.font_scale_ = (float)this.line_height_ / 9.0f;
            return this;
        }

        public MultiLineTextBox onValueChanged(Consumer<MultiLineTextBox> cb) {
            this.on_changed_ = cb;
            return this;
        }

        public MultiLineTextBox onMouseMove(BiConsumer<MultiLineTextBox, Guis.Coord2d> cb) {
            this.on_mouse_move_ = cb;
            return this;
        }

        public int getIndexUnderMouse(double mouseX, double mouseY) {
            return this.font_ == null ? 0 : this.getDisplayCache().getIndexAtPosition(this.font_, this.screenCoordinates(Guis.Coord2d.of((int)mouseX, (int)mouseY), false));
        }

        public Guis.Coord2d getCoordinatesAtIndex(int textIndex) {
            if (this.font_ == null) {
                return Guis.Coord2d.ORIGIN;
            }
            int lindex = MultiLineTextBox.findLineFromPos(this.getDisplayCache().lineStarts, textIndex = Mth.m_14045_((int)textIndex, (int)0, (int)this.getDisplayCache().fullText.length()));
            if (lindex < 0 || lindex >= this.getDisplayCache().lineStarts.length) {
                return Guis.Coord2d.ORIGIN;
            }
            LineInfo li = this.getDisplayCache().lines[lindex];
            textIndex -= this.getDisplayCache().lineStarts[lindex];
            textIndex = Mth.m_14045_((int)textIndex, (int)0, (int)li.contents.length());
            int ox = (int)this.font_.m_92865_().m_92353_(li.contents.substring(0, textIndex));
            int oy = this.getDisplayCache().lines[0].y;
            return Guis.Coord2d.of(li.x + ox * this.line_height_ / 9, oy + (li.y - oy) * this.line_height_ / 9);
        }

        public String getWordAtPosition(Guis.Coord2d xy) {
            return "";
        }

        @Override
        public MultiLineTextBox init(Screen parent) {
            return this.init(parent, Guis.Coord2d.of(this.m_252754_(), this.m_252907_()));
        }

        @Override
        public MultiLineTextBox init(Screen parent, Guis.Coord2d position) {
            super.init(parent, position);
            this.font_ = Minecraft.m_91087_().f_91062_;
            this.font_color_ = -16777216;
            this.cursor_color_ = -16777216;
            this.clearDisplayCache();
            return this;
        }

        public boolean m_6375_(double x, double y, int button) {
            if (!this.f_93623_ || !this.f_93624_ || x < (double)this.m_252754_() || y < (double)this.m_252907_() || x > (double)(this.m_252754_() + this.f_93618_) || y > (double)(this.m_252907_() + this.f_93619_)) {
                return false;
            }
            if (button != 0) {
                return true;
            }
            Guis.Coord2d sc = this.screenCoordinates(Guis.Coord2d.of((int)x, (int)y), false);
            int index = this.getDisplayCache().getIndexAtPosition(this.font_, Guis.Coord2d.of(sc.x * 9 / this.line_height_, sc.y * 9 / this.line_height_));
            if (index >= 0) {
                if (index == this.last_index_ && Util.m_137550_() - this.last_clicked_ < 250L) {
                    if (this.edit_.m_95198_()) {
                        this.edit_.m_95188_();
                    } else {
                        this.edit_.m_95147_(StringSplitter.m_92355_((String)this.getText(), (int)-1, (int)index, (boolean)false), StringSplitter.m_92355_((String)this.getText(), (int)1, (int)index, (boolean)false));
                    }
                } else {
                    this.edit_.m_95179_(index, Screen.m_96638_());
                }
                this.clearDisplayCache();
            }
            this.last_index_ = index;
            this.last_clicked_ = index;
            if (this.m_93696_()) {
                this.m_93692_(true);
            }
            return true;
        }

        public boolean m_7979_(double x, double y, int button, double dx, double dy) {
            if (super.m_7979_(x, y, button, dx, dy) || button != 0) {
                return true;
            }
            if (!this.f_93623_ || !this.f_93624_) {
                return false;
            }
            Guis.Coord2d sc = this.screenCoordinates(Guis.Coord2d.of((int)x, (int)y), false);
            this.edit_.m_95179_(this.getDisplayCache().getIndexAtPosition(this.font_, Guis.Coord2d.of(sc.x * 9 / this.line_height_, sc.y * 9 / this.line_height_)), true);
            this.clearDisplayCache();
            return true;
        }

        public boolean m_5534_(char key, int code) {
            if (super.m_5534_(key, code)) {
                return true;
            }
            if (!this.f_93623_ || !this.f_93624_) {
                return false;
            }
            if (!SharedConstants.m_136188_((char)key)) {
                return false;
            }
            this.edit_.m_95158_(Character.toString(key));
            this.clearDisplayCache();
            this.on_changed_.accept(this);
            return true;
        }

        public boolean m_7933_(int key, int x, int y) {
            if (super.m_7933_(key, x, y)) {
                return true;
            }
            if (!this.f_93623_ || !this.f_93624_) {
                return false;
            }
            String text_before = this.text_;
            if (!this.specialKeyMatched(key)) {
                return this.m_93696_();
            }
            this.clearDisplayCache();
            if (key == 257 && !this.edit_.m_95198_() && this.edit_.m_95194_() < this.text_.length() - 2) {
                int cp = this.edit_.m_95194_();
                this.edit_.m_95188_();
                this.edit_.m_95158_(MultiLineTextBox.eotTrimmed(this.text_));
                this.edit_.m_169100_(cp);
                this.edit_.m_95179_(cp, false);
            }
            if (!text_before.equals(this.text_)) {
                this.on_changed_.accept(this);
            }
            return true;
        }

        @Override
        protected void m_87963_(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
            if (!this.f_93624_) {
                return;
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int ox = (int)((double)this.m_252754_() * (1.0 - (double)this.font_scale_));
            int oy = (int)((double)this.m_252907_() * (1.0 - (double)this.font_scale_));
            PoseStack mxs = gg.m_280168_();
            mxs.m_85836_();
            mxs.m_252880_((float)ox, (float)oy, 0.0f);
            mxs.m_85841_(this.font_scale_, this.font_scale_, this.font_scale_);
            DisplayCache cache = this.getDisplayCache();
            for (LineInfo li : cache.lines) {
                gg.m_280430_(this.font_, li.asComponent, li.x, li.y, this.font_color_);
            }
            this.renderCursor(gg, cache.cursor, cache.cursorAtEnd);
            this.renderHighlight(cache.selection);
            Guis.Coord2d xy = this.getMousePosition();
            if (xy.x >= 0 && xy.y >= 0 && xy.x < this.f_93618_ && xy.y < this.f_93619_) {
                this.on_mouse_move_.accept(this, this.getMousePosition());
            }
            mxs.m_85849_();
        }

        private static String eotTrimmed(String text) {
            return text.replaceAll("\\s+$", "\n");
        }

        private String getText() {
            return this.text_;
        }

        private void setText(String text) {
            this.text_ = text;
            this.clearDisplayCache();
        }

        private void setClipboard(String text) {
            if (Minecraft.m_91087_() != null) {
                TextFieldHelper.m_95155_((Minecraft)Minecraft.m_91087_(), (String)MultiLineTextBox.eotTrimmed(text));
            }
        }

        private String getClipboard() {
            return Minecraft.m_91087_() != null ? MultiLineTextBox.eotTrimmed(TextFieldHelper.m_95169_((Minecraft)Minecraft.m_91087_())) : "";
        }

        private boolean specialKeyMatched(int key) {
            if (Screen.m_96634_((int)key)) {
                this.edit_.m_95188_();
                return true;
            }
            if (Screen.m_96632_((int)key)) {
                this.edit_.m_95178_();
                return true;
            }
            if (Screen.m_96630_((int)key)) {
                this.edit_.m_95165_();
                return true;
            }
            if (Screen.m_96628_((int)key)) {
                this.edit_.m_95142_();
                return true;
            }
            switch (key) {
                case 257: 
                case 335: {
                    this.edit_.m_95158_("\n");
                    return true;
                }
                case 259: {
                    this.edit_.m_95189_(-1);
                    return true;
                }
                case 261: {
                    this.edit_.m_95189_(1);
                    return true;
                }
                case 262: {
                    this.edit_.m_95150_(1, Screen.m_96638_());
                    return true;
                }
                case 263: {
                    this.edit_.m_95150_(-1, Screen.m_96638_());
                    return true;
                }
                case 264: {
                    this.changeLine(1);
                    return true;
                }
                case 265: {
                    this.changeLine(-1);
                    return true;
                }
                case 266: {
                    this.edit_.m_95179_(0, Screen.m_96638_());
                    return true;
                }
                case 267: {
                    this.edit_.m_95179_(this.text_.length(), Screen.m_96638_());
                    return true;
                }
                case 268: {
                    this.edit_.m_95179_(this.getDisplayCache().findLineStart(this.edit_.m_95194_()), Screen.m_96638_());
                    return true;
                }
                case 269: {
                    this.edit_.m_95179_(this.getDisplayCache().findLineEnd(this.edit_.m_95194_()), Screen.m_96638_());
                    return true;
                }
            }
            return false;
        }

        private void changeLine(int incr) {
            this.edit_.m_95179_(this.getDisplayCache().changeLine(this.edit_.m_95194_(), incr), Screen.m_96638_());
        }

        private void renderCursor(GuiGraphics gg, Guis.Coord2d pos, boolean at_end) {
            if (!this.f_93623_ || !this.f_93624_) {
                this.frame_tick_ = 0;
            }
            if ((++this.frame_tick_ & 0x3F) < 32) {
                return;
            }
            pos = this.screenCoordinates(pos, true);
            if (!at_end) {
                gg.m_280509_(pos.x, pos.y - 1, pos.x + 1, pos.y + 9, this.cursor_color_);
            } else {
                gg.m_280488_(this.font_, "_", pos.x, pos.y, this.cursor_color_);
            }
        }

        private void renderHighlight(Rect2i[] line_rects) {
            RenderSystem.setShader(GameRenderer::m_172808_);
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
            RenderSystem.enableColorLogicOp();
            RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
            BufferBuilder buf = Tesselator.m_85913_().m_85915_();
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
            double ox = (double)this.m_252754_() * (1.0 - (double)this.font_scale_);
            double oy = (double)this.m_252907_() * (1.0 - (double)this.font_scale_);
            for (Rect2i rc : line_rects) {
                int x0 = (int)Math.floor(ox + (double)rc.m_110085_() * (double)this.font_scale_) - 1;
                int y0 = (int)Math.floor(oy + (double)rc.m_110086_() * (double)this.font_scale_) - 1;
                int x1 = (int)Math.ceil((double)x0 + (double)rc.m_110090_() * (double)this.font_scale_);
                int y1 = (int)Math.ceil((double)y0 + (double)rc.m_110091_() * (double)this.font_scale_) - 1;
                buf.m_5483_((double)x0, (double)y1, 0.0).m_5752_();
                buf.m_5483_((double)x1, (double)y1, 0.0).m_5752_();
                buf.m_5483_((double)x1, (double)y0, 0.0).m_5752_();
                buf.m_5483_((double)x0, (double)y0, 0.0).m_5752_();
            }
            Tesselator.m_85913_().m_85914_();
            RenderSystem.disableColorLogicOp();
        }

        private DisplayCache getDisplayCache() {
            if (this.display_cache_ == null) {
                this.display_cache_ = this.rebuildDisplayCache();
            }
            return this.display_cache_;
        }

        private void clearDisplayCache() {
            this.display_cache_ = null;
        }

        private DisplayCache rebuildDisplayCache() {
            Guis.Coord2d ppos;
            boolean cur_at_eos;
            String full_text = this.getText();
            if (full_text.isEmpty()) {
                return DisplayCache.EMPTY;
            }
            int cur_pos = this.edit_.m_95194_();
            int sel_pos = this.edit_.m_95197_();
            IntArrayList lsp = new IntArrayList();
            ArrayList line_infos = Lists.newArrayList();
            MutableInt line_no = new MutableInt();
            MutableBoolean line_terminated = new MutableBoolean();
            StringSplitter ssp = this.font_.m_92865_();
            ssp.m_92364_(full_text, this.f_93618_ * 9 / this.line_height_, Style.f_131099_, true, (arg_0, arg_1, arg_2) -> this.lambda$rebuildDisplayCache$3(full_text, line_terminated, (IntList)lsp, line_no, line_infos, arg_0, arg_1, arg_2));
            int[] line_starts = lsp.toIntArray();
            boolean bl = cur_at_eos = cur_pos == full_text.length();
            if (cur_at_eos && line_terminated.isTrue()) {
                ppos = new Guis.Coord2d(0, line_infos.size() * 9);
            } else {
                int lno = MultiLineTextBox.findLineFromPos(line_starts, cur_pos);
                int lpx = this.font_.m_92895_(full_text.substring(line_starts[lno], cur_pos));
                ppos = new Guis.Coord2d(lpx, lno * 9);
            }
            ArrayList selection_blocks = Lists.newArrayList();
            if (cur_pos != sel_pos) {
                int k1;
                int l2 = Math.min(cur_pos, sel_pos);
                int i1 = Math.max(cur_pos, sel_pos);
                int j1 = MultiLineTextBox.findLineFromPos(line_starts, l2);
                if (j1 == (k1 = MultiLineTextBox.findLineFromPos(line_starts, i1))) {
                    int l1 = j1 * 9;
                    int i2 = line_starts[j1];
                    selection_blocks.add(this.createPartialLineSelection(full_text, ssp, l2, i1, l1, i2));
                } else {
                    int i3 = j1 + 1 > line_starts.length ? full_text.length() : line_starts[j1 + 1];
                    selection_blocks.add(this.createPartialLineSelection(full_text, ssp, l2, i3, j1 * 9, line_starts[j1]));
                    for (int j3 = j1 + 1; j3 < k1; ++j3) {
                        int j2 = j3 * 9;
                        String s1 = full_text.substring(line_starts[j3], line_starts[j3 + 1]);
                        int k2 = (int)ssp.m_92353_(s1);
                        selection_blocks.add(this.createSelection(new Guis.Coord2d(0, j2), new Guis.Coord2d(k2, j2 + 9)));
                    }
                    selection_blocks.add(this.createPartialLineSelection(full_text, ssp, line_starts[k1], i1, k1 * 9, line_starts[k1]));
                }
            }
            return new DisplayCache(full_text, ppos, cur_at_eos, line_starts, line_infos.toArray(new LineInfo[0]), selection_blocks.toArray(new Rect2i[0]));
        }

        private static int findLineFromPos(int[] line_starts, int cursor_pos) {
            int i = Arrays.binarySearch(line_starts, cursor_pos);
            return i < 0 ? -(i + 2) : i;
        }

        private Rect2i createPartialLineSelection(String text, StringSplitter ssp, int spos, int epos, int liney, int line_start_pos) {
            String s0 = text.substring(line_start_pos, spos);
            String s1 = text.substring(line_start_pos, epos).replaceAll("[\\r\\n]+$", "");
            return this.createSelection(new Guis.Coord2d((int)ssp.m_92353_(s0), liney), new Guis.Coord2d((int)ssp.m_92353_(s1), liney + 9));
        }

        private Rect2i createSelection(Guis.Coord2d pos1, Guis.Coord2d pos2) {
            Guis.Coord2d cd1 = this.screenCoordinates(pos1, true);
            Guis.Coord2d cd2 = this.screenCoordinates(pos2, true);
            int x0 = Math.min(cd1.x, cd2.x);
            int x1 = Math.max(cd1.x, cd2.x);
            int y0 = Math.min(cd1.y, cd2.y);
            int y1 = Math.max(cd1.y, cd2.y);
            return new Rect2i(x0, y0, x1 - x0, y1 - y0);
        }

        private /* synthetic */ void lambda$rebuildDisplayCache$3(String full_text, MutableBoolean line_terminated, IntList lsp, MutableInt line_no, List line_infos, Style text, int spos, int epos) {
            String full_line = full_text.substring(spos, epos);
            line_terminated.setValue(full_line.endsWith("\n"));
            String line = StringUtils.stripEnd((String)full_line, (String)" \n");
            lsp.add(spos);
            Guis.Coord2d pxy = this.screenCoordinates(new Guis.Coord2d(0, line_no.getAndIncrement() * 9), true);
            line_infos.add(new LineInfo(text, line, pxy.x, pxy.y));
        }

        @OnlyIn(value=Dist.CLIENT)
        static class DisplayCache {
            static final DisplayCache EMPTY = new DisplayCache("", new Guis.Coord2d(0, 0), true, new int[]{0}, new LineInfo[]{new LineInfo(Style.f_131099_, "", 0, 0)}, new Rect2i[0]);
            private final String fullText;
            final Guis.Coord2d cursor;
            final boolean cursorAtEnd;
            private final int[] lineStarts;
            final LineInfo[] lines;
            final Rect2i[] selection;

            public DisplayCache(String text, Guis.Coord2d cur, boolean at_end, int[] line_starts, LineInfo[] line_data, Rect2i[] sel) {
                this.fullText = text;
                this.cursor = cur;
                this.cursorAtEnd = at_end;
                this.lineStarts = line_starts;
                this.lines = line_data;
                this.selection = sel;
            }

            public int getIndexAtPosition(Font font, Guis.Coord2d pos) {
                int i = pos.y / 9;
                if (i < 0) {
                    return 0;
                }
                if (i >= this.lines.length) {
                    return this.fullText.length();
                }
                return this.lineStarts[i] + font.m_92865_().m_92360_(this.lines[i].contents, pos.x, this.lines[i].style);
            }

            public int changeLine(int cursor_pos, int length) {
                int k;
                int i = MultiLineTextBox.findLineFromPos(this.lineStarts, cursor_pos);
                int j = i + length;
                if (0 <= j && j < this.lineStarts.length) {
                    int l = cursor_pos - this.lineStarts[i];
                    int i1 = this.lines[j].contents.length();
                    k = this.lineStarts[j] + Math.min(l, i1);
                } else {
                    k = cursor_pos;
                }
                return k;
            }

            public int findLineStart(int cursor_pos) {
                int i = MultiLineTextBox.findLineFromPos(this.lineStarts, cursor_pos);
                return this.lineStarts[i];
            }

            public int findLineEnd(int cursor_pos) {
                int i = MultiLineTextBox.findLineFromPos(this.lineStarts, cursor_pos);
                return this.lineStarts[i] + this.lines[i].contents.length();
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        static class LineInfo {
            final Style style;
            final String contents;
            final Component asComponent;
            final int x;
            final int y;

            public LineInfo(Style fs, String s, int x0, int y0) {
                this.style = fs;
                this.contents = s;
                this.x = x0;
                this.y = y0;
                this.asComponent = Component.m_237113_((String)this.contents).m_6270_(this.style);
            }
        }
    }
}

